// Pepe Gallardo

#include "primWin32Aux.h"

static char errorMsg [2048];

char* _getErrorMsg () {
 return errorMsg;	 
}



void setErrorMsg (char *header) {
  LPVOID lpMsgBuf ; 
  
  FormatMessage( FORMAT_MESSAGE_ALLOCATE_BUFFER | FORMAT_MESSAGE_FROM_SYSTEM | FORMAT_MESSAGE_IGNORE_INSERTS
               , NULL
               , GetLastError()
               , MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT) 
               , (LPTSTR) &lpMsgBuf 
               , 0
               , NULL
               );
               
  wsprintf(errorMsg, "%s. Windows error code(%u): %s", header, GetLastError(), (LPCTSTR)lpMsgBuf); 
  
  LocalFree( lpMsgBuf );

}


HANDLE _lockFile (char *FilePath) {
  HANDLE     hFile;
  OVERLAPPED o;
  
  o.Offset     = 0;
  o.OffsetHigh = 0;
  o.hEvent     = 0;
  
  hFile = 
   CreateFile( (LPCTSTR)FilePath
             , GENERIC_READ | GENERIC_WRITE
             , FILE_SHARE_READ | FILE_SHARE_WRITE
             , NULL
             , OPEN_ALWAYS
             , FILE_ATTRIBUTE_NORMAL
             , NULL
             );
   
  if (hFile == INVALID_HANDLE_VALUE) { 
    setErrorMsg("_lockFile failed in CreateFile");	
    return NULL;
  } 
  
  if (!LockFileEx( hFile 
                 , LOCKFILE_EXCLUSIVE_LOCK
                 , 0
                 , 1 // lock first byte 
                 , 0 
                 , &o
                 )) {
    setErrorMsg("_lockFile failed in LockFileEx");
    return NULL;
  }   
	
  return hFile;
}

BOOL _unlockFile (HANDLE hFile) {
  OVERLAPPED o;
  
  o.Offset     = 0;
  o.OffsetHigh = 0;
  o.hEvent     = 0;

  if (!UnlockFileEx( hFile
                   , 0
                   , 1 
                   , 0
                   , &o    
                   )) {
                   	
    setErrorMsg("_unlockFile failed in UnlockFileEx");
    return FALSE;
  }                 	
    
  CloseHandle(hFile); 
  return TRUE;
	
}





